<?php
defined('ABSPATH') || die('Access Denied!');

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;

final class WC_SEP_BLOCK extends AbstractPaymentMethodType
{


    public $name = 'WC_Sep_Payment_Gateway';
    private $gateway;

    public function initialize()
    {

        $this->settings = get_option('woocommerce_' . $this->name . '_settings');
        $this->gateway = new WC_Sep_Payment_Gateway();
    }

    public function is_active()
    {
        return $this->gateway->is_available();
    }


    public function get_payment_method_data()
    {
        return array(
            'id' => $this->gateway->id,
            'title' => $this->gateway->title,
            'description' => $this->gateway->description,
            'icon' => $this->gateway->icon,
            'enabled' => $this->gateway->is_available(),
            'OrderButtonLabel' => __('Continue for payment.', 'sb24wc'),
            'supports' => $this->get_supported_features(),
            'pluginUrl' => SEP_WOO_IRANDARGAH_URL,
        );
    }

    public function get_payment_method_script_handles()
    {

        wp_register_script(
            'SEP_BLOCK_SETTINGS', SEP_WOO_IRANDARGAH_URL . 'assets/js/block-settings.js', ['wc-blocks-registry', 'wc-settings', 'wp-element'], '1', true
        );

        return ['SEP_BLOCK_SETTINGS'];
    }
}
