<?php
/*
Plugin Name: درگاه پرداخت «باهمتا»
Plugin URI: https://bahamta.com/
Description: درگاه پرداخت باهمتا در ووکامرس یک درگاه پرداخت آنلاین برای فروشگاه‌ها و سایت‌ها است که به منظور دریافت پول از مشتریان استفاده می‌شود. پرداخت‌ها به پول رایح ایران و تسویه‌ها در بانک‌های ایرانی انجام پذیر است.
Version: 0.1.0
Author: Bahamta
Author URI: https://bahamta.com/
License: GPLv2 or later
Text Domain: bahamta
*/

defined( 'ABSPATH' ) or die( 'No way to run scripts your way here!' );

// Make sure WooCommerce is active
if ( ! in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) return;

add_action( 'plugins_loaded', 'bahamta_payment_gateway_init', 11);

add_filter( 'woocommerce_payment_gateways', 'add_bahamta_gateway_class' );
function add_bahamta_gateway_class( $gateways ) {
	$gateways[] = 'bahamta_payment_gateway';
	return $gateways;
}

function bahamta_payment_gateway_init() {
    add_filter('woocommerce_currencies', 'add_bahamta_IR_currency');

    function add_bahamta_IR_currency($currencies)
    {
        $currencies['IRR'] = __('ریال', 'woocommerce');
        $currencies['IRT'] = __('تومان', 'woocommerce');

        return $currencies;
    }

    add_filter('woocommerce_currency_symbol', 'add_bahamta_IR_currency_symbol', 10, 2);

    function add_bahamta_IR_currency_symbol($currency_symbol, $currency)
    {
        switch ($currency) {
            case 'IRR':
                $currency_symbol = 'ریال';
                break;
            case 'IRT':
                $currency_symbol = 'تومان';
                break;
        }
        return $currency_symbol;
    }

    add_filter('woocommerce_bahamta_convert_to_IRR', 'bahamta_convert_to_IRR', 10, 2);

    function bahamta_convert_to_IRR($amount, $currency) {
        $amount = apply_filters('woocommerce_order_amount_total_IRANIAN_gateways_before_check_currency', $amount, $currency);

        if (strtolower($currency) == strtolower('IRT') || strtolower($currency) == strtolower('TOMAN') || strtolower($currency) == strtolower('Iran TOMAN') || strtolower($currency) == strtolower('Iranian TOMAN') || strtolower($currency) == strtolower('Iran-TOMAN') || strtolower($currency) == strtolower('Iranian-TOMAN') || strtolower($currency) == strtolower('Iran_TOMAN') || strtolower($currency) == strtolower('Iranian_TOMAN') || strtolower($currency) == strtolower('تومان') || strtolower($currency) == strtolower('تومان ایران')
        )
            $amount = $amount * 10;
        else if (strtolower($currency) == strtolower('IRR'))
            $amount = $amount * 1;

        $amount = apply_filters('woocommerce_order_amount_total_IRANIAN_gateways_after_check_currency', $amount, $currency);
        $amount = apply_filters('woocommerce_order_amount_total_IRANIAN_gateways_irt', $amount, $currency);

		return $amount;
    }

	class Bahamta_Payment_Gateway extends WC_Payment_Gateway {

		function __construct() {
			$this->id = 'bahamta_payment_gateway';
			$this->icon = WP_PLUGIN_URL . '/' . plugin_basename(dirname(__FILE__)) .'/images/bahamta.ico';
			$this->has_fields = false;
			$this->method_title = 'باهمتا';
			$this->method_description = 'درگاه امن پرداخت باهمتا';

			$this->gateway_url = "https://webpay.bahamta.com/api";

			$this->supports = array(
				'products'
			);

			// Method with all the options fields
			$this->init_form_fields();

			// Load the settings.
			$this->init_settings();

			$this->title = $this->get_option( 'title' );
			$this->description = $this->get_option( 'description' );
			$this->enabled = $this->get_option( 'enabled' );
			$this->succ_msg = $this->get_option( 'succeeded_message' );
			$this->fail_msg = $this->get_option( 'failed_message' );
			$this->cancel_msg = $this->get_option( 'canceled_message' );
			$this->api_key = $this->get_option( 'api_key' );
			$this->simulation_api_key = $this->get_option( 'simulation_api_key' );

			// // We need custom JavaScript to obtain a token
			// add_action( 'wp_enqueue_scripts', array( $this, 'payment_scripts' ) );

            if (version_compare(WOOCOMMERCE_VERSION, '2.0.0', '>='))
                add_action('woocommerce_update_options_payment_gateways_' . $this->id, array($this, 'process_admin_options'));
            else
                add_action('woocommerce_update_options_payment_gateways', array($this, 'process_admin_options'));

            add_action('woocommerce_receipt_' . $this->id, array($this, 'go_to_pay'));

            add_action('woocommerce_api_' . strtolower(get_class($this)), array($this, 'confirm'));
		}

		public function init_form_fields() {
			$this->form_fields = apply_filters('wc_bahamta_config', array(
				'enabled' => array(
					'title'       => 'فعال/غیرفعال',
					'label'       => 'فعالسازی درگاه پرداخت «باهمتا»',
					'type'        => 'checkbox',
					'description' => '',
					'default'     => 'no'
				),
				'title' => array(
					'title'       => 'عنوان',
					'type'        => 'text',
					'description' => 'این عنوانی است که خریدار به عنوان نام درگاه می‌بیند.',
					'default'     => 'باهمتا',
					'desc_tip'    => true,
				),
				'description' => array(
					'title'       => 'توضیح',
					'type'        => 'textarea',
					'description' => 'این توضیحی است که خریدار به عنوان شرح درگاه می‌بیند.',
					'default'     => 'پرداخت از طریق درگاه امن «باهمتا»',
				),
				'succeeded_message' => array(
					'title'       => 'پیام پرداخت موفق',
					'type'        => 'textarea',
					'description' => 'این پیام برای خرید موفق نمایش داده می‌شود.',
					'default'     => 'پرداخت با موفقیت انجام شد.',
				),
				'failed_message' => array(
					'title'       => 'پیام پرداخت ناموفق',
					'type'        => 'textarea',
					'description' => 'این پیام برای خرید ناموفق نمایش داده می‌شود.',
					'default'     => 'پرداخت با خطا روبرو شد.',
				),
				'canceled_message' => array(
					'title'       => 'پیام انصراف از پرداخت',
					'type'        => 'textarea',
					'description' => 'این پیام برای انصراف از خرید نمایش داده می‌شود.',
					'default'     => 'پرداخت از طرف خریدار لغو شد.',
				),
                'api_key' => array(
                    'title' => __('کلید درگاه پرداخت', 'woocommerce'),
                    'type' => 'text',
                    'description' => __('کلید اتصال به درگاه پرداخت', 'woocommerce'),
                    'default' => '',
                    'desc_tip' => true
                )
			));
		}

		/*
 		 * Fields validation
		 */
		public function validate_fields() {
  
		}

		/*
		 * We're processing the payments here
		 */
		public function process_payment( $order_id ) {
			global $woocommerce;

			// we need it to get any order detailes
			$order = wc_get_order( $order_id );

			return array(
                    'result' => 'success',
                    'redirect' => add_query_arg(
			    		array('order_id' => $order_id),
                    $order->get_checkout_payment_url(true))
                );
	 	}

	 	public function go_to_pay() {

	 		$order_id = $_GET['order_id'];

			$host_url = get_site_url();
			$callback_url = $host_url . "/wc-api/Bahamta_Payment_Gateway";

			$order = wc_get_order($order_id);
			if (is_wp_error($order)) {
				$this->handle_error($order);
				return;
			}

            $currency = $order->get_order_currency();
            $currency = apply_filters('WC_Vandario_Currency', $currency, $order);

			$amount = $this->get_order_total();
            $amount = apply_filters('woocommerce_bahamta_convert_to_IRR', $amount, $currency);

			$args = array(
			    'method'      => 'GET',
			    'timeout'     => 45,
			    'redirection' => 5,
			    'httpversion' => '1.0',
			    'blocking'    => true,
			);

			$url = add_query_arg( array(
			    'api_key' => $this->api_key,
			    'reference' => $order_id,
			    'amount_irr' => $amount,
			    'callback_url' => urlencode($callback_url),
			    'payer_mobile' => $order->get_billing_phone()),
				$this->gateway_url . '/create_request' );

			$response = wp_remote_get( $url, $args );
			error_log("response -> $response");
			if (is_wp_error($response)) {
				$this->handle_error($response);
				return;
			}

			$code = (int)$response['response']['code'];
			$body = $response['body'];

			if ($code == 200) {
				$params = json_decode($body);
				if ($params->ok) {
					wp_redirect($params->result->payment_url);
					return;
				} else {
					$this->show_error($this->fail_msg);
				}
			} else {
				$this->show_error($this->fail_msg);	
			}
	 	}

	 	public function confirm() {
	 		global $woocommerce;

	 		$reference = $_GET['reference'];
	 		$err_code = $_GET['error_key'];
	 		$err_msg = $_GET['error_message'];
	 		$test_mode = $_GET['test_mode'] == 'true';

	 		if ($err_code != "") {
	 			switch ($err_code) {
	 				case 1:
	 					$msg = $this->cancel_msg;
	 					break;
	 				default:
	 					$msg = $this->fail_msg;
	 					break;
	 			}
	 			$this->show_error($msg);
				return;
	 		}

			$order = wc_get_order($reference);
			if (is_wp_error($order)) {
				$this->handle_error($order);
				return;
			}

            $currency = $order->get_order_currency();
            $currency = apply_filters('WC_Vandario_Currency', $currency, $order);

			$amount = $this->get_order_total();
            $amount = apply_filters('woocommerce_bahamta_convert_to_IRR', $amount, $currency);

			$args = array(
			    'method'      => 'GET',
			    'timeout'     => 45,
			    'redirection' => 5,
			    'httpversion' => '1.0',
			    'blocking'    => true,
			);

			$url = add_query_arg( array(
			    'api_key' => $this->api_key,
			    'reference' => $reference,
			    'amount_irr' => $amount,
			    'test_mode' => ($test_mode ? 'true' : 'false')),
				$this->gateway_url . '/confirm_payment' );

			$response = wp_remote_get( $url, $args );
			if (is_wp_error($response)) {
				$this->handle_error($response);
				return;
			}

			$body = $response['body'];
			$params = json_decode($body);

			if ($params->result->state == 'paid' &&
		        $params->result->bill_id == $bill_id) {
				wp_redirect($this->get_return_url($order));
				$order->payment_complete($Transaction_ID);
                $woocommerce->cart->empty_cart();
                wc_add_notice($this->succ_msg);
			}
	 	}

		public function handle_error( $wp_error ) {
	 		if (is_wp_error($wp_error)) {
				$err_code = $wp_error->get_error_code();
				switch ($err_code) {
					case "http_request_failed":
						$err_msg = "ارتباط با درگاه امن باهمتا برقرار نشد.";
						break;
					default:
						$err_msg = $this->fail_msg;
						break;
				}

				$this->show_error($err_msg);
			}
	 	}

	 	public function show_error( $err_msg ) {
			$shop_page_url = get_permalink( woocommerce_get_page_id( 'shop' ) );
			wp_redirect($shop_page_url);
			wc_add_notice($err_msg, "error");	 		
	 	}
	}
}
